// battle sequence and actions
public class Battle
{
    public IPlayer HeroesPlayer { get; }
    public IPlayer MonstersPlayer { get; }
    public Party Heroes { get; }
    public Party Monsters => _monsterParties[_currentRound];
    
    private Party[] _monsterParties;
    private int _currentRound;
    

    public Battle(IPlayer heroesPlayer, IPlayer monstersPlayer, Party heroes, Party[] monsterParties)
    {
        HeroesPlayer = heroesPlayer;
        MonstersPlayer = monstersPlayer;
        Heroes = heroes;
        _monsterParties = monsterParties;
        _currentRound = 0;
    }

    public void Run()
    {
        while (true)
        {
            //heroes
            RunParty(HeroesPlayer, Heroes);
            
            if (IsHeroPartyEliminated || AreAllMonsterPartiesEliminated) break;
            if (IsCurrentMonsterPartyEliminated)
            {
                AdvanceRound();
                continue;
            }
            //munstersss
            RunParty(MonstersPlayer, Monsters);
            
            if (IsHeroPartyEliminated || AreAllMonsterPartiesEliminated) break;
            if (IsCurrentMonsterPartyEliminated) 
            {
                    AdvanceRound();
                    continue;
            }
        }

        DisplayGameResult();
    }

    private void AdvanceRound()
    {
        _currentRound++;
        ConsolePlus.WriteLine("WAVE DEFEATED! ADVANCING", ConsoleColor.Magenta);
    }
    //method for win /loss
    private void DisplayGameResult()
    {
        if (AreAllMonsterPartiesEliminated) ConsolePlus.WriteLine("You have won! The Uncoded one has been defeated!", ConsoleColor.Green);
        else ConsolePlus.WriteLine("You have lost. The Uncoded One's reign will remain.", ConsoleColor.Red);
    }
    // flag to stop game
    private bool IsBattleOver => IsHeroPartyEliminated || IsCurrentMonsterPartyEliminated;
    private bool IsHeroPartyEliminated => !Heroes.Characters.Any();
private bool IsCurrentMonsterPartyEliminated 
{
    get
    {
        return Monsters != null && Monsters.Characters.All(c => c.CurrentHealth <= 0);
    }
}
    private bool AreAllMonsterPartiesEliminated => IsCurrentMonsterPartyEliminated && _currentRound == _monsterParties.Length - 1;
    private void HandlePotentialDeaths()
    { 
        {
            foreach(Character character in Heroes.Characters.Concat(Monsters.Characters).ToList())
                if (!character.IsAlive)
                {
                    Heroes.Characters.Remove(character);
                    Monsters.Characters.Remove(character);
                }
        }
    }
    private void RunParty(IPlayer player, Party party)
    {
      foreach(Character character in party.Characters.ToList())
      {
          if (!character.IsAlive) continue;
            ConsolePlus.WriteLine("---------------------------------------------",ConsoleColor.Cyan);
            ConsolePlus.WriteLine($"It is {character.Name}'s turn....", ConsoleColor.White);
            IAction chosenAction = player.TakeTurn(character, this);
            chosenAction.Execute();
            HandlePotentialDeaths();
            
            if (IsBattleOver) return;

          
      }
    }
}

// party characters
public class Party
{
    public List<Character> Characters { get; }

    public Party(IEnumerable<Character> startingCharacters)
    {
        Characters = startingCharacters.ToList();
    }
    
}